function Figure1F()
% This script plots the data from Figure 1F. Data is stored within files as
% individual replicates (e.g. mAb_1 = data from replicate 1, mAb_2 = data
% from replicate 2, etc.). Data is stored as mAb intensity per particle, C3
% intensity per particle, and F intensity per particle.

fnames = ls('*.mat');
K = size(fnames,1);

for k = 1:K
  current = fnames(k,:);
  load(current);
  A = [mAb_1 mAb_2 mAb_3];
  C = [C3_1 C3_2 C3_3];
  F = [F_1 F_2 F_3];

  [N,x] = hist3([log10(A)',log10(C)'],'Ctrs',{0:.2:7 0:.2:7});
  N = N./max(max(N));
  
  inrec = find(log10(C)>=4);
  R = length(inrec)/length(C);
  S = num2str(R*100); S = [S(1:4),'%'];
  
  v0 = [0.05:0.1:1];
  figure; 
  [M,junk] = contour(x{1},x{2},N',v0); close
  lowest = 1;
  while lowest == 1;
    lev = M(1,1);
    v = M(2,1); xy = M(:,2:(1+v))';
    in = inpolygon(log10(A),log10(C),xy(:,1),xy(:,2));
    A(in) = []; C(in) = [];
    M(:,1:(1+v)) = [];
    next_lev = M(1,1);
    if(next_lev == lev); lowest = 1;
    else lowest = 0; end
  end
  
  i = find(current=='.'); mAb_name = current(1:(i-1));

  figure; plot(log10(A),log10(C),'.','Color',[0.5 0.5 0.5]); title(current); xlim([0 7]); ylim([0 7]); axis square; hold on;
  text(.2,6.7,S,'FontSize',12,'FontWeight','bold');
  contour(x{1},x{2},N',v0,'LineWidth',1.5); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); title(mAb_name); axis square; 
  plot([.1 6.9 6.9 .1 .1],[4 4 6.9 6.9 4],'k--','LineWidth',1.5);
  ylabel('log10[C3 intensity per particle]'); xlabel('log10[mAb intensity per particle]');
  drawnow;
end


  